<?php

namespace AreanetMigration;

use Shopware\Components\Plugin;

class AreanetMigration extends Plugin
{
    /**
     * @inheritdoc
     */
    public static function getSubscribedEvents()
    {
        return [
            'Enlight_Controller_Dispatcher_ControllerPath_Api_Migration' => 'onGetMigrationApiController',
            'Enlight_Controller_Dispatcher_ControllerPath_Api_Attributes' => 'onGetAttributesApiController',
            'Enlight_Controller_Dispatcher_ControllerPath_Api_Units' => 'onGetUnitsApiController',
            'Enlight_Controller_Dispatcher_ControllerPath_Api_ArticleImage' => 'onGetArticleImageApiController'
        ];
    }

    /**
     * @return string
     */
    public function onGetMigrationApiController()
    {
        return $this->getPath() . '/Controllers/Api/Migration.php';
    }

    /**
     * @return string
     */
    public function onGetAttributesApiController()
    {
        return $this->getPath() . '/Controllers/Api/Attributes.php';
    }

    /**
     * @return string
     */
    public function onGetUnitsApiController()
    {
        return $this->getPath() . '/Controllers/Api/Units.php';
    }

    /**
     * @return string
     */
    public function onGetArticleImageApiController()
    {
        return $this->getPath() . '/Controllers/Api/ArticleImage.php';
    }
}
